/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.engine;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.jcs.engine.behavior.ICacheListener;
import org.apache.commons.jcs.engine.behavior.ICacheObserver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CacheWatchRepairable
implements ICacheObserver {
    private static final Log log = LogFactory.getLog(CacheWatchRepairable.class);
    private ICacheObserver cacheWatch;
    private final Map<String, Set<ICacheListener<?, ?>>> cacheMap = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCacheWatch(ICacheObserver cacheWatch) {
        this.cacheWatch = cacheWatch;
        Map<String, Set<ICacheListener<?, ?>>> map = this.cacheMap;
        synchronized (map) {
            for (Map.Entry<String, Set<ICacheListener<?, ?>>> entry : this.cacheMap.entrySet()) {
                String cacheName = entry.getKey();
                for (ICacheListener<?, ?> listener : entry.getValue()) {
                    try {
                        if (log.isInfoEnabled()) {
                            log.info("Adding listener to cache watch. ICacheListener = " + listener + " | ICacheObserver = " + cacheWatch);
                        }
                        cacheWatch.addCacheListener(cacheName, listener);
                    }
                    catch (IOException ex) {
                        log.error("Problem adding listener. ICacheListener = " + listener + " | ICacheObserver = " + cacheWatch, ex);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <K, V> void addCacheListener(String cacheName, ICacheListener<K, V> obj) throws IOException {
        Map<String, Set<ICacheListener<?, ?>>> map = this.cacheMap;
        synchronized (map) {
            Set<ICacheListener<?, ?>> listenerSet = this.cacheMap.get(cacheName);
            if (listenerSet == null) {
                listenerSet = new HashSet();
                this.cacheMap.put(cacheName, listenerSet);
            }
            listenerSet.add(obj);
        }
        if (log.isInfoEnabled()) {
            log.info("Adding listener to cache watch. ICacheListener = " + obj + " | ICacheObserver = " + this.cacheWatch + " | cacheName = " + cacheName);
        }
        this.cacheWatch.addCacheListener(cacheName, obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <K, V> void addCacheListener(ICacheListener<K, V> obj) throws IOException {
        Map<String, Set<ICacheListener<?, ?>>> map = this.cacheMap;
        synchronized (map) {
            for (Set<ICacheListener<?, ?>> listenerSet : this.cacheMap.values()) {
                listenerSet.add(obj);
            }
        }
        if (log.isInfoEnabled()) {
            log.info("Adding listener to cache watch. ICacheListener = " + obj + " | ICacheObserver = " + this.cacheWatch);
        }
        this.cacheWatch.addCacheListener(obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <K, V> void removeCacheListener(String cacheName, ICacheListener<K, V> obj) throws IOException {
        if (log.isInfoEnabled()) {
            log.info("removeCacheListener, cacheName [" + cacheName + "]");
        }
        Map<String, Set<ICacheListener<?, ?>>> map = this.cacheMap;
        synchronized (map) {
            Set<ICacheListener<?, ?>> listenerSet = this.cacheMap.get(cacheName);
            if (listenerSet != null) {
                listenerSet.remove(obj);
            }
        }
        this.cacheWatch.removeCacheListener(cacheName, obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <K, V> void removeCacheListener(ICacheListener<K, V> obj) throws IOException {
        if (log.isInfoEnabled()) {
            log.info("removeCacheListener, ICacheListener [" + obj + "]");
        }
        Map<String, Set<ICacheListener<?, ?>>> map = this.cacheMap;
        synchronized (map) {
            for (Set<ICacheListener<?, ?>> listenerSet : this.cacheMap.values()) {
                if (log.isDebugEnabled()) {
                    log.debug("Before removing [" + obj + "] the listenerSet = " + listenerSet);
                }
                listenerSet.remove(obj);
            }
        }
        this.cacheWatch.removeCacheListener(obj);
    }
}

