/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.engine;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.jcs.engine.behavior.ICache;
import org.apache.commons.jcs.engine.behavior.ICacheEventQueue;

public class CacheListeners<K, V> {
    public final ICache<K, V> cache;
    public final Map<Long, ICacheEventQueue<K, V>> eventQMap = new ConcurrentHashMap<Long, ICacheEventQueue<K, V>>();

    public CacheListeners(ICache<K, V> cache) {
        if (cache == null) {
            throw new IllegalArgumentException("cache must not be null");
        }
        this.cache = cache;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("\n CacheListeners");
        if (this.cache != null) {
            buffer.append("\n Region = " + this.cache.getCacheName());
        }
        if (this.eventQMap != null) {
            buffer.append("\n Event Queue Map ");
            buffer.append("\n size = " + this.eventQMap.size());
            Iterator<Map.Entry<Long, ICacheEventQueue<K, V>>> it = this.eventQMap.entrySet().iterator();
            while (it.hasNext()) {
                buffer.append("\n Entry: " + it.next());
            }
        } else {
            buffer.append("\n No Listeners. ");
        }
        return buffer.toString();
    }
}

