/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.auxiliary.lateral;

import org.apache.commons.jcs.auxiliary.lateral.behavior.ILateralCacheManager;
import org.apache.commons.jcs.auxiliary.lateral.behavior.ILateralCacheObserver;
import org.apache.commons.jcs.engine.behavior.ICacheServiceNonLocal;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LateralCacheRestore {
    private static final Log log = LogFactory.getLog(LateralCacheRestore.class);
    private final ILateralCacheManager lcm;
    private boolean canFix = true;
    private Object lateralObj;

    public LateralCacheRestore(ILateralCacheManager lcm) {
        this.lcm = lcm;
    }

    public boolean canFix() {
        if (!this.canFix) {
            return this.canFix;
        }
        try {
            this.lateralObj = this.lcm.fixService();
        }
        catch (Exception ex) {
            log.error("Can't fix " + ex.getMessage());
            this.canFix = false;
        }
        return this.canFix;
    }

    public void fix() {
        if (!this.canFix) {
            return;
        }
        this.lcm.fixCaches((ICacheServiceNonLocal)this.lateralObj, (ILateralCacheObserver)this.lateralObj);
        String msg = "Lateral connection resumed.";
        log.info(msg);
    }
}

