/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.auxiliary.lateral;

import org.apache.commons.jcs.auxiliary.lateral.LateralCacheNoWait;
import org.apache.commons.jcs.auxiliary.lateral.LateralCacheRestore;
import org.apache.commons.jcs.auxiliary.lateral.behavior.ILateralCacheManager;
import org.apache.commons.jcs.engine.CacheStatus;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LateralCacheMonitor
implements Runnable {
    private static final Log log = LogFactory.getLog(LateralCacheMonitor.class);
    private static long idlePeriod = 20000L;
    private boolean alright = true;
    private boolean shutdown = false;
    private static int mode = 1;
    private final ILateralCacheManager manager;

    public static void setIdlePeriod(long idlePeriod) {
        if (idlePeriod > LateralCacheMonitor.idlePeriod) {
            LateralCacheMonitor.idlePeriod = idlePeriod;
        }
    }

    protected static void forceShortIdlePeriod(long idlePeriod) {
        LateralCacheMonitor.idlePeriod = idlePeriod;
    }

    public LateralCacheMonitor(ILateralCacheManager manager) {
        this.manager = manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyError() {
        this.bad();
        LateralCacheMonitor lateralCacheMonitor = this;
        synchronized (lateralCacheMonitor) {
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyShutdown() {
        LateralCacheMonitor lateralCacheMonitor = this;
        synchronized (lateralCacheMonitor) {
            this.shutdown = true;
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            LateralCacheMonitor lateralCacheMonitor;
            if (mode == 1) {
                if (log.isDebugEnabled()) {
                    if (this.alright) {
                        log.debug("ERROR DRIVEN MODE: alright = " + this.alright + ", connection monitor will wait for an error.");
                    } else {
                        log.debug("ERROR DRIVEN MODE: alright = " + this.alright + " connection monitor running.");
                    }
                }
                lateralCacheMonitor = this;
                synchronized (lateralCacheMonitor) {
                    if (this.alright) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
            }
            log.debug("TIME DRIVEN MODE: connection monitor will sleep for " + idlePeriod + " after this run.");
            lateralCacheMonitor = this;
            synchronized (lateralCacheMonitor) {
                if (this.shutdown) {
                    log.info("Shutting down cache monitor");
                    return;
                }
            }
            lateralCacheMonitor = this;
            synchronized (lateralCacheMonitor) {
                this.alright = true;
            }
            if (log.isDebugEnabled()) {
                log.debug("Cache monitor running.");
            }
            log.info("LateralCacheManager.instances.size() = " + this.manager.getInstances().size());
            int cnt = 0;
            for (ILateralCacheManager iLateralCacheManager : this.manager.getInstances().values()) {
                ++cnt;
                try {
                    log.info("\n " + cnt + "- mgr.getCaches().size() = " + iLateralCacheManager.getCaches().size());
                    if (iLateralCacheManager.getCaches().size() == 0 && mode == 1) {
                        this.bad();
                    }
                    for (LateralCacheNoWait<?, ?> c : iLateralCacheManager.getCaches().values()) {
                        if (c.getStatus() == CacheStatus.ERROR) {
                            log.info("found LateralCacheNoWait in error, " + c.toString());
                            LateralCacheRestore repairer = new LateralCacheRestore(iLateralCacheManager);
                            if (repairer.canFix()) {
                                repairer.fix();
                                continue;
                            }
                            this.bad();
                            continue;
                        }
                        log.info("Lateral Cache No Wait not in error");
                    }
                }
                catch (Exception ex) {
                    this.bad();
                    log.error("Problem encountered in fixing the caches", ex);
                }
            }
            try {
                if (log.isDebugEnabled()) {
                    log.debug("Lateral cache monitor sleeping for " + idlePeriod + " between runs.");
                }
                Thread.sleep(idlePeriod);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bad() {
        if (this.alright) {
            LateralCacheMonitor lateralCacheMonitor = this;
            synchronized (lateralCacheMonitor) {
                this.alright = false;
            }
        }
    }
}

