/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.tiff;

import com.drew.imaging.tiff.TiffHandler;
import com.drew.lang.Rational;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import java.util.Stack;

public abstract class DirectoryTiffHandler
implements TiffHandler {
    private final Stack<Directory> _directoryStack = new Stack();
    protected Directory _currentDirectory;
    protected final Metadata _metadata;

    protected DirectoryTiffHandler(Metadata metadata, Class<? extends Directory> initialDirectory) {
        this._metadata = metadata;
        this._currentDirectory = this._metadata.getOrCreateDirectory(initialDirectory);
    }

    @Override
    public void endingIFD() {
        this._currentDirectory = this._directoryStack.empty() ? null : this._directoryStack.pop();
    }

    protected void pushDirectory(Class<? extends Directory> directoryClass) {
        assert (directoryClass != this._currentDirectory.getClass());
        this._directoryStack.push(this._currentDirectory);
        this._currentDirectory = this._metadata.getOrCreateDirectory(directoryClass);
    }

    @Override
    public void warn(String message) {
        this._currentDirectory.addError(message);
    }

    @Override
    public void error(String message) {
        this._currentDirectory.addError(message);
    }

    @Override
    public void setByteArray(int tagId, byte[] bytes) {
        this._currentDirectory.setByteArray(tagId, bytes);
    }

    @Override
    public void setString(int tagId, String string) {
        this._currentDirectory.setString(tagId, string);
    }

    @Override
    public void setRational(int tagId, Rational rational) {
        this._currentDirectory.setRational(tagId, rational);
    }

    @Override
    public void setRationalArray(int tagId, Rational[] array) {
        this._currentDirectory.setRationalArray(tagId, array);
    }

    @Override
    public void setFloat(int tagId, float float32) {
        this._currentDirectory.setFloat(tagId, float32);
    }

    @Override
    public void setFloatArray(int tagId, float[] array) {
        this._currentDirectory.setFloatArray(tagId, array);
    }

    @Override
    public void setDouble(int tagId, double double64) {
        this._currentDirectory.setDouble(tagId, double64);
    }

    @Override
    public void setDoubleArray(int tagId, double[] array) {
        this._currentDirectory.setDoubleArray(tagId, array);
    }

    @Override
    public void setInt8s(int tagId, byte int8s) {
        this._currentDirectory.setInt(tagId, int8s);
    }

    @Override
    public void setInt8sArray(int tagId, byte[] array) {
        this._currentDirectory.setByteArray(tagId, array);
    }

    @Override
    public void setInt8u(int tagId, short int8u) {
        this._currentDirectory.setInt(tagId, int8u);
    }

    @Override
    public void setInt8uArray(int tagId, short[] array) {
        this._currentDirectory.setObjectArray(tagId, array);
    }

    @Override
    public void setInt16s(int tagId, int int16s) {
        this._currentDirectory.setInt(tagId, int16s);
    }

    @Override
    public void setInt16sArray(int tagId, short[] array) {
        this._currentDirectory.setObjectArray(tagId, array);
    }

    @Override
    public void setInt16u(int tagId, int int16u) {
        this._currentDirectory.setInt(tagId, int16u);
    }

    @Override
    public void setInt16uArray(int tagId, int[] array) {
        this._currentDirectory.setObjectArray(tagId, array);
    }

    @Override
    public void setInt32s(int tagId, int int32s) {
        this._currentDirectory.setInt(tagId, int32s);
    }

    @Override
    public void setInt32sArray(int tagId, int[] array) {
        this._currentDirectory.setIntArray(tagId, array);
    }

    @Override
    public void setInt32u(int tagId, long int32u) {
        this._currentDirectory.setLong(tagId, int32u);
    }

    @Override
    public void setInt32uArray(int tagId, long[] array) {
        this._currentDirectory.setObjectArray(tagId, array);
    }
}

