/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.iptc;

import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;

public final class Iso2022Converter {
    public static String convertISO2022CharsetToJavaCharset(byte[] bytes) {
        if (bytes.length > 2 && bytes[0] == 27 && bytes[1] == 37 && bytes[2] == 71) {
            return "UTF-8";
        }
        if (bytes.length > 3 && bytes[0] == 27 && (bytes[3] & 0xFF | (bytes[2] & 0xFF) << 8 | (bytes[1] & 0xFF) << 16) == 14844066 && bytes[4] == 65) {
            return "ISO-8859-1";
        }
        return null;
    }

    static String guessEncoding(byte[] bytes) {
        String[] encodings;
        for (String encoding : encodings = new String[]{"UTF-8", System.getProperty("file.encoding"), "ISO-8859-1"}) {
            CharsetDecoder cs = Charset.forName(encoding).newDecoder();
            try {
                cs.decode(ByteBuffer.wrap(bytes));
                return encoding;
            }
            catch (CharacterCodingException characterCodingException) {
            }
        }
        return null;
    }
}

