/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.iptc;

import com.drew.imaging.jpeg.JpegSegmentMetadataReader;
import com.drew.imaging.jpeg.JpegSegmentType;
import com.drew.lang.SequentialByteArrayReader;
import com.drew.lang.SequentialReader;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.iptc.IptcDirectory;
import com.drew.metadata.iptc.Iso2022Converter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;

public class IptcReader
implements JpegSegmentMetadataReader {
    @Override
    public Iterable<JpegSegmentType> getSegmentTypes() {
        return Arrays.asList(JpegSegmentType.APPD);
    }

    @Override
    public boolean canProcess(byte[] segmentBytes, JpegSegmentType segmentType) {
        return segmentBytes.length != 0 && segmentBytes[0] == 28;
    }

    @Override
    public void extract(byte[] segmentBytes, Metadata metadata, JpegSegmentType segmentType) {
        this.extract(new SequentialByteArrayReader(segmentBytes), metadata, segmentBytes.length);
    }

    public void extract(SequentialReader reader, Metadata metadata, long length) {
        IptcDirectory directory = metadata.getOrCreateDirectory(IptcDirectory.class);
        int offset = 0;
        while ((long)offset < length) {
            int tagByteCount;
            short tagType;
            short directoryType;
            short startByte;
            try {
                startByte = reader.getUInt8();
                ++offset;
            }
            catch (IOException e) {
                directory.addError("Unable to read starting byte of IPTC tag");
                return;
            }
            if (startByte != 28) {
                if ((long)offset != length) {
                    directory.addError("Invalid IPTC tag marker at offset " + (offset - 1) + ". Expected '0x1c' but got '0x" + Integer.toHexString(startByte) + "'.");
                }
                return;
            }
            if ((long)(offset + 5) >= length) {
                directory.addError("Too few bytes remain for a valid IPTC tag");
                return;
            }
            try {
                directoryType = reader.getUInt8();
                tagType = reader.getUInt8();
                tagByteCount = reader.getUInt16();
            }
            catch (IOException e) {
                directory.addError("IPTC data segment ended mid-way through tag descriptor");
                return;
            }
            if ((long)((offset += 4) + tagByteCount) > length) {
                directory.addError("Data for tag extends beyond end of IPTC segment");
                return;
            }
            try {
                this.processTag(reader, directory, directoryType, tagType, tagByteCount);
            }
            catch (IOException e) {
                directory.addError("Error processing IPTC tag");
                return;
            }
            offset += tagByteCount;
        }
    }

    private void processTag(SequentialReader reader, Directory directory, int directoryType, int tagType, int tagByteCount) throws IOException {
        int tagIdentifier = tagType | directoryType << 8;
        if (tagByteCount == 0) {
            directory.setString(tagIdentifier, "");
            return;
        }
        String string = null;
        switch (tagIdentifier) {
            case 346: {
                byte[] bytes = reader.getBytes(tagByteCount);
                String charset = Iso2022Converter.convertISO2022CharsetToJavaCharset(bytes);
                if (charset == null) {
                    string = new String(bytes);
                    break;
                }
                directory.setString(tagIdentifier, charset);
                return;
            }
            case 256: 
            case 278: 
            case 378: 
            case 512: 
            case 582: {
                if (tagByteCount < 2) break;
                int shortValue = reader.getUInt16();
                reader.skip(tagByteCount - 2);
                directory.setInt(tagIdentifier, shortValue);
                return;
            }
            case 522: {
                directory.setInt(tagIdentifier, reader.getUInt8());
                reader.skip(tagByteCount - 1);
                return;
            }
            case 542: 
            case 567: {
                if (tagByteCount >= 8) {
                    string = reader.getString(tagByteCount);
                    try {
                        int year = Integer.parseInt(string.substring(0, 4));
                        int month = Integer.parseInt(string.substring(4, 6)) - 1;
                        int day = Integer.parseInt(string.substring(6, 8));
                        Date date = new GregorianCalendar(year, month, day).getTime();
                        directory.setDate(tagIdentifier, date);
                        return;
                    }
                    catch (NumberFormatException numberFormatException) {
                        break;
                    }
                }
                reader.skip(tagByteCount);
            }
        }
        if (string == null) {
            String encoding = directory.getString(346);
            if (encoding != null) {
                string = reader.getString(tagByteCount, encoding);
            } else {
                byte[] bytes = reader.getBytes(tagByteCount);
                encoding = Iso2022Converter.guessEncoding(bytes);
                String string2 = string = encoding != null ? new String(bytes, encoding) : new String(bytes);
            }
        }
        if (directory.containsTag(tagIdentifier)) {
            String[] newStrings;
            String[] oldStrings = directory.getStringArray(tagIdentifier);
            if (oldStrings == null) {
                newStrings = new String[1];
            } else {
                newStrings = new String[oldStrings.length + 1];
                System.arraycopy(oldStrings, 0, newStrings, 0, oldStrings.length);
            }
            newStrings[newStrings.length - 1] = string;
            directory.setStringArray(tagIdentifier, newStrings);
        } else {
            directory.setString(tagIdentifier, string);
        }
    }
}

