/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.iptc;

import com.drew.lang.StringUtil;
import com.drew.metadata.TagDescriptor;
import com.drew.metadata.iptc.IptcDirectory;

public class IptcDescriptor
extends TagDescriptor<IptcDirectory> {
    public IptcDescriptor(IptcDirectory directory) {
        super(directory);
    }

    @Override
    public String getDescription(int tagType) {
        switch (tagType) {
            case 276: {
                return this.getFileFormatDescription();
            }
            case 537: {
                return this.getKeywordsDescription();
            }
        }
        return super.getDescription(tagType);
    }

    public String getFileFormatDescription() {
        Integer value = ((IptcDirectory)this._directory).getInteger(276);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                return "No ObjectData";
            }
            case 1: {
                return "IPTC-NAA Digital Newsphoto Parameter Record";
            }
            case 2: {
                return "IPTC7901 Recommended Message Format";
            }
            case 3: {
                return "Tagged Image File Format (Adobe/Aldus Image data)";
            }
            case 4: {
                return "Illustrator (Adobe Graphics data)";
            }
            case 5: {
                return "AppleSingle (Apple Computer Inc)";
            }
            case 6: {
                return "NAA 89-3 (ANPA 1312)";
            }
            case 7: {
                return "MacBinary II";
            }
            case 8: {
                return "IPTC Unstructured Character Oriented File Format (UCOFF)";
            }
            case 9: {
                return "United Press International ANPA 1312 variant";
            }
            case 10: {
                return "United Press International Down-Load Message";
            }
            case 11: {
                return "JPEG File Interchange (JFIF)";
            }
            case 12: {
                return "Photo-CD Image-Pac (Eastman Kodak)";
            }
            case 13: {
                return "Bit Mapped Graphics File [.BMP] (Microsoft)";
            }
            case 14: {
                return "Digital Audio File [.WAV] (Microsoft & Creative Labs)";
            }
            case 15: {
                return "Audio plus Moving Video [.AVI] (Microsoft)";
            }
            case 16: {
                return "PC DOS/Windows Executable Files [.COM][.EXE]";
            }
            case 17: {
                return "Compressed Binary File [.ZIP] (PKWare Inc)";
            }
            case 18: {
                return "Audio Interchange File Format AIFF (Apple Computer Inc)";
            }
            case 19: {
                return "RIFF Wave (Microsoft Corporation)";
            }
            case 20: {
                return "Freehand (Macromedia/Aldus)";
            }
            case 21: {
                return "Hypertext Markup Language [.HTML] (The Internet Society)";
            }
            case 22: {
                return "MPEG 2 Audio Layer 2 (Musicom), ISO/IEC";
            }
            case 23: {
                return "MPEG 2 Audio Layer 3, ISO/IEC";
            }
            case 24: {
                return "Portable Document File [.PDF] Adobe";
            }
            case 25: {
                return "News Industry Text Format (NITF)";
            }
            case 26: {
                return "Tape Archive [.TAR]";
            }
            case 27: {
                return "Tidningarnas Telegrambyra NITF version (TTNITF DTD)";
            }
            case 28: {
                return "Ritzaus Bureau NITF version (RBNITF DTD)";
            }
            case 29: {
                return "Corel Draw [.CDR]";
            }
        }
        return String.format("Unknown (%d)", value);
    }

    public String getByLineDescription() {
        return ((IptcDirectory)this._directory).getString(592);
    }

    public String getByLineTitleDescription() {
        return ((IptcDirectory)this._directory).getString(597);
    }

    public String getCaptionDescription() {
        return ((IptcDirectory)this._directory).getString(632);
    }

    public String getCategoryDescription() {
        return ((IptcDirectory)this._directory).getString(527);
    }

    public String getCityDescription() {
        return ((IptcDirectory)this._directory).getString(602);
    }

    public String getCopyrightNoticeDescription() {
        return ((IptcDirectory)this._directory).getString(628);
    }

    public String getCountryOrPrimaryLocationDescription() {
        return ((IptcDirectory)this._directory).getString(613);
    }

    public String getCreditDescription() {
        return ((IptcDirectory)this._directory).getString(622);
    }

    public String getDateCreatedDescription() {
        return ((IptcDirectory)this._directory).getString(567);
    }

    public String getHeadlineDescription() {
        return ((IptcDirectory)this._directory).getString(617);
    }

    public String getKeywordsDescription() {
        CharSequence[] keywords = ((IptcDirectory)this._directory).getStringArray(537);
        if (keywords == null) {
            return null;
        }
        return StringUtil.join((CharSequence[])keywords, (String)";");
    }

    public String getObjectNameDescription() {
        return ((IptcDirectory)this._directory).getString(517);
    }

    public String getOriginalTransmissionReferenceDescription() {
        return ((IptcDirectory)this._directory).getString(615);
    }

    public String getOriginatingProgramDescription() {
        return ((IptcDirectory)this._directory).getString(577);
    }

    public String getProvinceOrStateDescription() {
        return ((IptcDirectory)this._directory).getString(607);
    }

    public String getRecordVersionDescription() {
        return ((IptcDirectory)this._directory).getString(512);
    }

    public String getReleaseDateDescription() {
        return ((IptcDirectory)this._directory).getString(542);
    }

    public String getReleaseTimeDescription() {
        return ((IptcDirectory)this._directory).getString(547);
    }

    public String getSourceDescription() {
        return ((IptcDirectory)this._directory).getString(627);
    }

    public String getSpecialInstructionsDescription() {
        return ((IptcDirectory)this._directory).getString(552);
    }

    public String getSupplementalCategoriesDescription() {
        return ((IptcDirectory)this._directory).getString(532);
    }

    public String getTimeCreatedDescription() {
        return ((IptcDirectory)this._directory).getString(572);
    }

    public String getUrgencyDescription() {
        return ((IptcDirectory)this._directory).getString(522);
    }

    public String getWriterDescription() {
        return ((IptcDirectory)this._directory).getString(634);
    }
}

