/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.exif.makernotes;

import com.drew.metadata.TagDescriptor;
import com.drew.metadata.exif.makernotes.CanonMakernoteDirectory;

public class CanonMakernoteDescriptor
extends TagDescriptor<CanonMakernoteDirectory> {
    public CanonMakernoteDescriptor(CanonMakernoteDirectory directory) {
        super(directory);
    }

    @Override
    public String getDescription(int tagType) {
        switch (tagType) {
            case 12: {
                return this.getSerialNumberDescription();
            }
            case 49436: {
                return this.getFlashActivityDescription();
            }
            case 49426: {
                return this.getFocusTypeDescription();
            }
            case 49420: {
                return this.getDigitalZoomDescription();
            }
            case 49411: {
                return this.getQualityDescription();
            }
            case 49409: {
                return this.getMacroModeDescription();
            }
            case 49410: {
                return this.getSelfTimerDelayDescription();
            }
            case 49412: {
                return this.getFlashModeDescription();
            }
            case 49413: {
                return this.getContinuousDriveModeDescription();
            }
            case 49415: {
                return this.getFocusMode1Description();
            }
            case 49418: {
                return this.getImageSizeDescription();
            }
            case 49419: {
                return this.getEasyShootingModeDescription();
            }
            case 49421: {
                return this.getContrastDescription();
            }
            case 49422: {
                return this.getSaturationDescription();
            }
            case 49423: {
                return this.getSharpnessDescription();
            }
            case 49424: {
                return this.getIsoDescription();
            }
            case 49425: {
                return this.getMeteringModeDescription();
            }
            case 49427: {
                return this.getAfPointSelectedDescription();
            }
            case 49428: {
                return this.getExposureModeDescription();
            }
            case 49431: {
                return this.getLongFocalLengthDescription();
            }
            case 49432: {
                return this.getShortFocalLengthDescription();
            }
            case 49433: {
                return this.getFocalUnitsPerMillimetreDescription();
            }
            case 49437: {
                return this.getFlashDetailsDescription();
            }
            case 49440: {
                return this.getFocusMode2Description();
            }
            case 49671: {
                return this.getWhiteBalanceDescription();
            }
            case 49678: {
                return this.getAfPointUsedDescription();
            }
            case 49679: {
                return this.getFlashBiasDescription();
            }
        }
        return super.getDescription(tagType);
    }

    public String getSerialNumberDescription() {
        Integer value = ((CanonMakernoteDirectory)this._directory).getInteger(12);
        if (value == null) {
            return null;
        }
        return String.format("%04X%05d", value >> 8 & 0xFF, value & 0xFF);
    }

    public String getFlashBiasDescription() {
        Integer value = ((CanonMakernoteDirectory)this._directory).getInteger(49679);
        if (value == null) {
            return null;
        }
        boolean isNegative = false;
        if (value > 61440) {
            isNegative = true;
            Integer n = value = Integer.valueOf(65535 - value);
            Integer n2 = value = Integer.valueOf(value + 1);
        }
        return (isNegative ? "-" : "") + Float.toString((float)value.intValue() / 32.0f) + " EV";
    }

    public String getAfPointUsedDescription() {
        Integer value = ((CanonMakernoteDirectory)this._directory).getInteger(49678);
        if (value == null) {
            return null;
        }
        if ((value & 7) == 0) {
            return "Right";
        }
        if ((value & 7) == 1) {
            return "Centre";
        }
        if ((value & 7) == 2) {
            return "Left";
        }
        return "Unknown (" + value + ")";
    }

    public String getWhiteBalanceDescription() {
        return this.getIndexedDescription(49671, "Auto", "Sunny", "Cloudy", "Tungsten", "Florescent", "Flash", "Custom");
    }

    public String getFocusMode2Description() {
        return this.getIndexedDescription(49440, "Single", "Continuous");
    }

    public String getFlashDetailsDescription() {
        Integer value = ((CanonMakernoteDirectory)this._directory).getInteger(49437);
        if (value == null) {
            return null;
        }
        if ((value >> 14 & 1) > 0) {
            return "External E-TTL";
        }
        if ((value >> 13 & 1) > 0) {
            return "Internal flash";
        }
        if ((value >> 11 & 1) > 0) {
            return "FP sync used";
        }
        if ((value >> 4 & 1) > 0) {
            return "FP sync enabled";
        }
        return "Unknown (" + value + ")";
    }

    public String getFocalUnitsPerMillimetreDescription() {
        Integer value = ((CanonMakernoteDirectory)this._directory).getInteger(49433);
        if (value == null) {
            return null;
        }
        if (value != 0) {
            return Integer.toString(value);
        }
        return "";
    }

    public String getShortFocalLengthDescription() {
        Integer value = ((CanonMakernoteDirectory)this._directory).getInteger(49432);
        if (value == null) {
            return null;
        }
        String units = this.getFocalUnitsPerMillimetreDescription();
        return Integer.toString(value) + " " + units;
    }

    public String getLongFocalLengthDescription() {
        Integer value = ((CanonMakernoteDirectory)this._directory).getInteger(49431);
        if (value == null) {
            return null;
        }
        String units = this.getFocalUnitsPerMillimetreDescription();
        return Integer.toString(value) + " " + units;
    }

    public String getExposureModeDescription() {
        return this.getIndexedDescription(49428, "Easy shooting", "Program", "Tv-priority", "Av-priority", "Manual", "A-DEP");
    }

    public String getAfPointSelectedDescription() {
        return this.getIndexedDescription(49427, 12288, "None (MF)", "Auto selected", "Right", "Centre", "Left");
    }

    public String getMeteringModeDescription() {
        return this.getIndexedDescription(49425, 3, "Evaluative", "Partial", "Centre weighted");
    }

    public String getIsoDescription() {
        Integer value = ((CanonMakernoteDirectory)this._directory).getInteger(49424);
        if (value == null) {
            return null;
        }
        int canonMask = 16384;
        if ((value & canonMask) > 0) {
            return "" + (value & ~canonMask);
        }
        switch (value) {
            case 0: {
                return "Not specified (see ISOSpeedRatings tag)";
            }
            case 15: {
                return "Auto";
            }
            case 16: {
                return "50";
            }
            case 17: {
                return "100";
            }
            case 18: {
                return "200";
            }
            case 19: {
                return "400";
            }
        }
        return "Unknown (" + value + ")";
    }

    public String getSharpnessDescription() {
        Integer value = ((CanonMakernoteDirectory)this._directory).getInteger(49423);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 65535: {
                return "Low";
            }
            case 0: {
                return "Normal";
            }
            case 1: {
                return "High";
            }
        }
        return "Unknown (" + value + ")";
    }

    public String getSaturationDescription() {
        Integer value = ((CanonMakernoteDirectory)this._directory).getInteger(49422);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 65535: {
                return "Low";
            }
            case 0: {
                return "Normal";
            }
            case 1: {
                return "High";
            }
        }
        return "Unknown (" + value + ")";
    }

    public String getContrastDescription() {
        Integer value = ((CanonMakernoteDirectory)this._directory).getInteger(49421);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 65535: {
                return "Low";
            }
            case 0: {
                return "Normal";
            }
            case 1: {
                return "High";
            }
        }
        return "Unknown (" + value + ")";
    }

    public String getEasyShootingModeDescription() {
        return this.getIndexedDescription(49419, "Full auto", "Manual", "Landscape", "Fast shutter", "Slow shutter", "Night", "B&W", "Sepia", "Portrait", "Sports", "Macro / Closeup", "Pan focus");
    }

    public String getImageSizeDescription() {
        return this.getIndexedDescription(49418, "Large", "Medium", "Small");
    }

    public String getFocusMode1Description() {
        return this.getIndexedDescription(49415, "One-shot", "AI Servo", "AI Focus", "Manual Focus", "Single", "Continuous", "Manual Focus");
    }

    public String getContinuousDriveModeDescription() {
        Integer value = ((CanonMakernoteDirectory)this._directory).getInteger(49413);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                Integer delay = ((CanonMakernoteDirectory)this._directory).getInteger(49410);
                if (delay != null) {
                    return delay == 0 ? "Single shot" : "Single shot with self-timer";
                }
            }
            case 1: {
                return "Continuous";
            }
        }
        return "Unknown (" + value + ")";
    }

    public String getFlashModeDescription() {
        Integer value = ((CanonMakernoteDirectory)this._directory).getInteger(49412);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                return "No flash fired";
            }
            case 1: {
                return "Auto";
            }
            case 2: {
                return "On";
            }
            case 3: {
                return "Red-eye reduction";
            }
            case 4: {
                return "Slow-synchro";
            }
            case 5: {
                return "Auto and red-eye reduction";
            }
            case 6: {
                return "On and red-eye reduction";
            }
            case 16: {
                return "External flash";
            }
        }
        return "Unknown (" + value + ")";
    }

    public String getSelfTimerDelayDescription() {
        Integer value = ((CanonMakernoteDirectory)this._directory).getInteger(49410);
        if (value == null) {
            return null;
        }
        if (value == 0) {
            return "Self timer not used";
        }
        return Double.toString((double)value.intValue() * 0.1) + " sec";
    }

    public String getMacroModeDescription() {
        return this.getIndexedDescription(49409, 1, "Macro", "Normal");
    }

    public String getQualityDescription() {
        return this.getIndexedDescription(49411, 2, "Normal", "Fine", null, "Superfine");
    }

    public String getDigitalZoomDescription() {
        return this.getIndexedDescription(49420, "No digital zoom", "2x", "4x");
    }

    public String getFocusTypeDescription() {
        Integer value = ((CanonMakernoteDirectory)this._directory).getInteger(49426);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                return "Manual";
            }
            case 1: {
                return "Auto";
            }
            case 3: {
                return "Close-up (Macro)";
            }
            case 8: {
                return "Locked (Pan Mode)";
            }
        }
        return "Unknown (" + value + ")";
    }

    public String getFlashActivityDescription() {
        return this.getIndexedDescription(49436, "Flash did not fire", "Flash fired");
    }
}

