/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.exif;

import com.drew.lang.GeoLocation;
import com.drew.lang.Rational;
import com.drew.metadata.TagDescriptor;
import com.drew.metadata.exif.GpsDirectory;
import java.text.DecimalFormat;

public class GpsDescriptor
extends TagDescriptor<GpsDirectory> {
    public GpsDescriptor(GpsDirectory directory) {
        super(directory);
    }

    @Override
    public String getDescription(int tagType) {
        switch (tagType) {
            case 0: {
                return this.getGpsVersionIdDescription();
            }
            case 6: {
                return this.getGpsAltitudeDescription();
            }
            case 5: {
                return this.getGpsAltitudeRefDescription();
            }
            case 9: {
                return this.getGpsStatusDescription();
            }
            case 10: {
                return this.getGpsMeasureModeDescription();
            }
            case 12: {
                return this.getGpsSpeedRefDescription();
            }
            case 14: 
            case 16: 
            case 23: {
                return this.getGpsDirectionReferenceDescription(tagType);
            }
            case 15: 
            case 17: 
            case 24: {
                return this.getGpsDirectionDescription(tagType);
            }
            case 25: {
                return this.getGpsDestinationReferenceDescription();
            }
            case 7: {
                return this.getGpsTimeStampDescription();
            }
            case 4: {
                return this.getGpsLongitudeDescription();
            }
            case 2: {
                return this.getGpsLatitudeDescription();
            }
            case 30: {
                return this.getGpsDifferentialDescription();
            }
        }
        return super.getDescription(tagType);
    }

    private String getGpsVersionIdDescription() {
        return this.getVersionBytesDescription(0, 1);
    }

    public String getGpsLatitudeDescription() {
        GeoLocation location = ((GpsDirectory)this._directory).getGeoLocation();
        return location == null ? null : GeoLocation.decimalToDegreesMinutesSecondsString(location.getLatitude());
    }

    public String getGpsLongitudeDescription() {
        GeoLocation location = ((GpsDirectory)this._directory).getGeoLocation();
        return location == null ? null : GeoLocation.decimalToDegreesMinutesSecondsString(location.getLongitude());
    }

    public String getGpsTimeStampDescription() {
        int[] timeComponents = ((GpsDirectory)this._directory).getIntArray(7);
        return timeComponents == null ? null : String.format("%d:%d:%d UTC", timeComponents[0], timeComponents[1], timeComponents[2]);
    }

    public String getGpsDestinationReferenceDescription() {
        String value = ((GpsDirectory)this._directory).getString(25);
        if (value == null) {
            return null;
        }
        String distanceRef = value.trim();
        if ("K".equalsIgnoreCase(distanceRef)) {
            return "kilometers";
        }
        if ("M".equalsIgnoreCase(distanceRef)) {
            return "miles";
        }
        if ("N".equalsIgnoreCase(distanceRef)) {
            return "knots";
        }
        return "Unknown (" + distanceRef + ")";
    }

    public String getGpsDirectionDescription(int tagType) {
        Rational angle = ((GpsDirectory)this._directory).getRational(tagType);
        String value = angle != null ? new DecimalFormat("0.##").format(angle.doubleValue()) : ((GpsDirectory)this._directory).getString(tagType);
        return value == null || value.trim().length() == 0 ? null : value.trim() + " degrees";
    }

    public String getGpsDirectionReferenceDescription(int tagType) {
        String value = ((GpsDirectory)this._directory).getString(tagType);
        if (value == null) {
            return null;
        }
        String gpsDistRef = value.trim();
        if ("T".equalsIgnoreCase(gpsDistRef)) {
            return "True direction";
        }
        if ("M".equalsIgnoreCase(gpsDistRef)) {
            return "Magnetic direction";
        }
        return "Unknown (" + gpsDistRef + ")";
    }

    public String getGpsSpeedRefDescription() {
        String value = ((GpsDirectory)this._directory).getString(12);
        if (value == null) {
            return null;
        }
        String gpsSpeedRef = value.trim();
        if ("K".equalsIgnoreCase(gpsSpeedRef)) {
            return "kph";
        }
        if ("M".equalsIgnoreCase(gpsSpeedRef)) {
            return "mph";
        }
        if ("N".equalsIgnoreCase(gpsSpeedRef)) {
            return "knots";
        }
        return "Unknown (" + gpsSpeedRef + ")";
    }

    public String getGpsMeasureModeDescription() {
        String value = ((GpsDirectory)this._directory).getString(10);
        if (value == null) {
            return null;
        }
        String gpsSpeedMeasureMode = value.trim();
        if ("2".equalsIgnoreCase(gpsSpeedMeasureMode)) {
            return "2-dimensional measurement";
        }
        if ("3".equalsIgnoreCase(gpsSpeedMeasureMode)) {
            return "3-dimensional measurement";
        }
        return "Unknown (" + gpsSpeedMeasureMode + ")";
    }

    public String getGpsStatusDescription() {
        String value = ((GpsDirectory)this._directory).getString(9);
        if (value == null) {
            return null;
        }
        String gpsStatus = value.trim();
        if ("A".equalsIgnoreCase(gpsStatus)) {
            return "Active (Measurement in progress)";
        }
        if ("V".equalsIgnoreCase(gpsStatus)) {
            return "Void (Measurement Interoperability)";
        }
        return "Unknown (" + gpsStatus + ")";
    }

    public String getGpsAltitudeRefDescription() {
        return this.getIndexedDescription(5, "Sea level", "Below sea level");
    }

    public String getGpsAltitudeDescription() {
        Rational value = ((GpsDirectory)this._directory).getRational(6);
        return value == null ? null : value.intValue() + " metres";
    }

    public String getGpsDifferentialDescription() {
        return this.getIndexedDescription(30, "No Correction", "Differential Corrected");
    }

    public String getDegreesMinutesSecondsDescription() {
        GeoLocation location = ((GpsDirectory)this._directory).getGeoLocation();
        return location == null ? null : location.toDMSString();
    }
}

