/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.exif;

import com.drew.metadata.Directory;
import com.drew.metadata.MetadataException;
import com.drew.metadata.exif.ExifThumbnailDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;

public class ExifThumbnailDirectory
extends Directory {
    public static final int TAG_THUMBNAIL_IMAGE_WIDTH = 256;
    public static final int TAG_THUMBNAIL_IMAGE_HEIGHT = 257;
    public static final int TAG_BITS_PER_SAMPLE = 258;
    public static final int TAG_THUMBNAIL_COMPRESSION = 259;
    public static final int TAG_PHOTOMETRIC_INTERPRETATION = 262;
    public static final int TAG_STRIP_OFFSETS = 273;
    public static final int TAG_ORIENTATION = 274;
    public static final int TAG_SAMPLES_PER_PIXEL = 277;
    public static final int TAG_ROWS_PER_STRIP = 278;
    public static final int TAG_STRIP_BYTE_COUNTS = 279;
    public static final int TAG_X_RESOLUTION = 282;
    public static final int TAG_Y_RESOLUTION = 283;
    public static final int TAG_PLANAR_CONFIGURATION = 284;
    public static final int TAG_RESOLUTION_UNIT = 296;
    public static final int TAG_THUMBNAIL_OFFSET = 513;
    public static final int TAG_THUMBNAIL_LENGTH = 514;
    public static final int TAG_YCBCR_COEFFICIENTS = 529;
    public static final int TAG_YCBCR_SUBSAMPLING = 530;
    public static final int TAG_YCBCR_POSITIONING = 531;
    public static final int TAG_REFERENCE_BLACK_WHITE = 532;
    protected static final HashMap<Integer, String> _tagNameMap = new HashMap();
    private byte[] _thumbnailData;

    public ExifThumbnailDirectory() {
        this.setDescriptor(new ExifThumbnailDescriptor(this));
    }

    @Override
    public String getName() {
        return "Exif Thumbnail";
    }

    @Override
    protected HashMap<Integer, String> getTagNameMap() {
        return _tagNameMap;
    }

    public boolean hasThumbnailData() {
        return this._thumbnailData != null;
    }

    public byte[] getThumbnailData() {
        return this._thumbnailData;
    }

    public void setThumbnailData(byte[] data) {
        this._thumbnailData = data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeThumbnail(String filename) throws MetadataException, IOException {
        byte[] data = this._thumbnailData;
        if (data == null) {
            throw new MetadataException("No thumbnail data exists.");
        }
        try (FileOutputStream stream = null;){
            stream = new FileOutputStream(filename);
            stream.write(data);
        }
    }

    static {
        _tagNameMap.put(256, "Thumbnail Image Width");
        _tagNameMap.put(257, "Thumbnail Image Height");
        _tagNameMap.put(258, "Bits Per Sample");
        _tagNameMap.put(259, "Thumbnail Compression");
        _tagNameMap.put(262, "Photometric Interpretation");
        _tagNameMap.put(273, "Strip Offsets");
        _tagNameMap.put(274, "Orientation");
        _tagNameMap.put(277, "Samples Per Pixel");
        _tagNameMap.put(278, "Rows Per Strip");
        _tagNameMap.put(279, "Strip Byte Counts");
        _tagNameMap.put(282, "X Resolution");
        _tagNameMap.put(283, "Y Resolution");
        _tagNameMap.put(284, "Planar Configuration");
        _tagNameMap.put(296, "Resolution Unit");
        _tagNameMap.put(513, "Thumbnail Offset");
        _tagNameMap.put(514, "Thumbnail Length");
        _tagNameMap.put(529, "YCbCr Coefficients");
        _tagNameMap.put(530, "YCbCr Sub-Sampling");
        _tagNameMap.put(531, "YCbCr Positioning");
        _tagNameMap.put(532, "Reference Black/White");
    }
}

