/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.exif;

import com.drew.imaging.PhotographicConversions;
import com.drew.lang.Rational;
import com.drew.metadata.TagDescriptor;
import com.drew.metadata.exif.ExifSubIFDDirectory;
import java.io.UnsupportedEncodingException;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;

public class ExifSubIFDDescriptor
extends TagDescriptor<ExifSubIFDDirectory> {
    private final boolean _allowDecimalRepresentationOfRationals = true;
    private static final DecimalFormat SimpleDecimalFormatter = new DecimalFormat("0.#");

    public ExifSubIFDDescriptor(ExifSubIFDDirectory directory) {
        super(directory);
    }

    @Override
    public String getDescription(int tagType) {
        switch (tagType) {
            case 254: {
                return this.getNewSubfileTypeDescription();
            }
            case 255: {
                return this.getSubfileTypeDescription();
            }
            case 263: {
                return this.getThresholdingDescription();
            }
            case 266: {
                return this.getFillOrderDescription();
            }
            case 33434: {
                return this.getExposureTimeDescription();
            }
            case 37377: {
                return this.getShutterSpeedDescription();
            }
            case 33437: {
                return this.getFNumberDescription();
            }
            case 37122: {
                return this.getCompressedAverageBitsPerPixelDescription();
            }
            case 37382: {
                return this.getSubjectDistanceDescription();
            }
            case 37383: {
                return this.getMeteringModeDescription();
            }
            case 37384: {
                return this.getWhiteBalanceDescription();
            }
            case 37385: {
                return this.getFlashDescription();
            }
            case 37386: {
                return this.getFocalLengthDescription();
            }
            case 40961: {
                return this.getColorSpaceDescription();
            }
            case 40962: {
                return this.getExifImageWidthDescription();
            }
            case 40963: {
                return this.getExifImageHeightDescription();
            }
            case 41488: {
                return this.getFocalPlaneResolutionUnitDescription();
            }
            case 41486: {
                return this.getFocalPlaneXResolutionDescription();
            }
            case 41487: {
                return this.getFocalPlaneYResolutionDescription();
            }
            case 258: {
                return this.getBitsPerSampleDescription();
            }
            case 262: {
                return this.getPhotometricInterpretationDescription();
            }
            case 278: {
                return this.getRowsPerStripDescription();
            }
            case 279: {
                return this.getStripByteCountsDescription();
            }
            case 277: {
                return this.getSamplesPerPixelDescription();
            }
            case 284: {
                return this.getPlanarConfigurationDescription();
            }
            case 530: {
                return this.getYCbCrSubsamplingDescription();
            }
            case 34850: {
                return this.getExposureProgramDescription();
            }
            case 37378: {
                return this.getApertureValueDescription();
            }
            case 37381: {
                return this.getMaxApertureValueDescription();
            }
            case 41495: {
                return this.getSensingMethodDescription();
            }
            case 37380: {
                return this.getExposureBiasDescription();
            }
            case 41728: {
                return this.getFileSourceDescription();
            }
            case 41729: {
                return this.getSceneTypeDescription();
            }
            case 37121: {
                return this.getComponentConfigurationDescription();
            }
            case 36864: {
                return this.getExifVersionDescription();
            }
            case 40960: {
                return this.getFlashPixVersionDescription();
            }
            case 34855: {
                return this.getIsoEquivalentDescription();
            }
            case 37510: {
                return this.getUserCommentDescription();
            }
            case 41985: {
                return this.getCustomRenderedDescription();
            }
            case 41986: {
                return this.getExposureModeDescription();
            }
            case 41987: {
                return this.getWhiteBalanceModeDescription();
            }
            case 41988: {
                return this.getDigitalZoomRatioDescription();
            }
            case 41989: {
                return this.get35mmFilmEquivFocalLengthDescription();
            }
            case 41990: {
                return this.getSceneCaptureTypeDescription();
            }
            case 41991: {
                return this.getGainControlDescription();
            }
            case 41992: {
                return this.getContrastDescription();
            }
            case 41993: {
                return this.getSaturationDescription();
            }
            case 41994: {
                return this.getSharpnessDescription();
            }
            case 41996: {
                return this.getSubjectDistanceRangeDescription();
            }
        }
        return super.getDescription(tagType);
    }

    public String getNewSubfileTypeDescription() {
        return this.getIndexedDescription(254, 1, "Full-resolution image", "Reduced-resolution image", "Single page of multi-page reduced-resolution image", "Transparency mask", "Transparency mask of reduced-resolution image", "Transparency mask of multi-page image", "Transparency mask of reduced-resolution multi-page image");
    }

    public String getSubfileTypeDescription() {
        return this.getIndexedDescription(255, 1, "Full-resolution image", "Reduced-resolution image", "Single page of multi-page image");
    }

    public String getThresholdingDescription() {
        return this.getIndexedDescription(263, 1, "No dithering or halftoning", "Ordered dither or halftone", "Randomized dither");
    }

    public String getFillOrderDescription() {
        return this.getIndexedDescription(266, 1, "Normal", "Reversed");
    }

    public String getSubjectDistanceRangeDescription() {
        return this.getIndexedDescription(41996, "Unknown", "Macro", "Close view", "Distant view");
    }

    public String getSharpnessDescription() {
        return this.getIndexedDescription(41994, "None", "Low", "Hard");
    }

    public String getSaturationDescription() {
        return this.getIndexedDescription(41993, "None", "Low saturation", "High saturation");
    }

    public String getContrastDescription() {
        return this.getIndexedDescription(41992, "None", "Soft", "Hard");
    }

    public String getGainControlDescription() {
        return this.getIndexedDescription(41991, "None", "Low gain up", "Low gain down", "High gain up", "High gain down");
    }

    public String getSceneCaptureTypeDescription() {
        return this.getIndexedDescription(41990, "Standard", "Landscape", "Portrait", "Night scene");
    }

    public String get35mmFilmEquivFocalLengthDescription() {
        Integer value = ((ExifSubIFDDirectory)this._directory).getInteger(41989);
        return value == null ? null : (value == 0 ? "Unknown" : SimpleDecimalFormatter.format(value) + "mm");
    }

    public String getDigitalZoomRatioDescription() {
        Rational value = ((ExifSubIFDDirectory)this._directory).getRational(41988);
        return value == null ? null : (value.getNumerator() == 0L ? "Digital zoom not used." : SimpleDecimalFormatter.format(value.doubleValue()));
    }

    public String getWhiteBalanceModeDescription() {
        return this.getIndexedDescription(41987, "Auto white balance", "Manual white balance");
    }

    public String getExposureModeDescription() {
        return this.getIndexedDescription(41986, "Auto exposure", "Manual exposure", "Auto bracket");
    }

    public String getCustomRenderedDescription() {
        return this.getIndexedDescription(41985, "Normal process", "Custom process");
    }

    public String getUserCommentDescription() {
        byte[] commentBytes = ((ExifSubIFDDirectory)this._directory).getByteArray(37510);
        if (commentBytes == null) {
            return null;
        }
        if (commentBytes.length == 0) {
            return "";
        }
        HashMap<String, String> encodingMap = new HashMap<String, String>();
        encodingMap.put("ASCII", System.getProperty("file.encoding"));
        encodingMap.put("UNICODE", "UTF-16LE");
        encodingMap.put("JIS", "Shift-JIS");
        try {
            if (commentBytes.length >= 10) {
                String firstTenBytesString = new String(commentBytes, 0, 10);
                for (Map.Entry pair : encodingMap.entrySet()) {
                    String encodingName = (String)pair.getKey();
                    String charset = (String)pair.getValue();
                    if (!firstTenBytesString.startsWith(encodingName)) continue;
                    for (int j = encodingName.length(); j < 10; ++j) {
                        byte b = commentBytes[j];
                        if (b == 0 || b == 32) continue;
                        return new String(commentBytes, j, commentBytes.length - j, charset).trim();
                    }
                    return new String(commentBytes, 10, commentBytes.length - 10, charset).trim();
                }
            }
            return new String(commentBytes, System.getProperty("file.encoding")).trim();
        }
        catch (UnsupportedEncodingException ex) {
            return null;
        }
    }

    public String getIsoEquivalentDescription() {
        Integer isoEquiv = ((ExifSubIFDDirectory)this._directory).getInteger(34855);
        return isoEquiv != null ? Integer.toString(isoEquiv) : null;
    }

    public String getExifVersionDescription() {
        return this.getVersionBytesDescription(36864, 2);
    }

    public String getFlashPixVersionDescription() {
        return this.getVersionBytesDescription(40960, 2);
    }

    public String getSceneTypeDescription() {
        return this.getIndexedDescription(41729, 1, "Directly photographed image");
    }

    public String getFileSourceDescription() {
        return this.getIndexedDescription(41728, 1, "Film Scanner", "Reflection Print Scanner", "Digital Still Camera (DSC)");
    }

    public String getExposureBiasDescription() {
        Rational value = ((ExifSubIFDDirectory)this._directory).getRational(37380);
        if (value == null) {
            return null;
        }
        return value.toSimpleString(true) + " EV";
    }

    public String getMaxApertureValueDescription() {
        Double aperture = ((ExifSubIFDDirectory)this._directory).getDoubleObject(37381);
        if (aperture == null) {
            return null;
        }
        double fStop = PhotographicConversions.apertureToFStop(aperture);
        return "F" + SimpleDecimalFormatter.format(fStop);
    }

    public String getApertureValueDescription() {
        Double aperture = ((ExifSubIFDDirectory)this._directory).getDoubleObject(37378);
        if (aperture == null) {
            return null;
        }
        double fStop = PhotographicConversions.apertureToFStop(aperture);
        return "F" + SimpleDecimalFormatter.format(fStop);
    }

    public String getExposureProgramDescription() {
        return this.getIndexedDescription(34850, 1, "Manual control", "Program normal", "Aperture priority", "Shutter priority", "Program creative (slow program)", "Program action (high-speed program)", "Portrait mode", "Landscape mode");
    }

    public String getYCbCrSubsamplingDescription() {
        int[] positions = ((ExifSubIFDDirectory)this._directory).getIntArray(530);
        if (positions == null) {
            return null;
        }
        if (positions[0] == 2 && positions[1] == 1) {
            return "YCbCr4:2:2";
        }
        if (positions[0] == 2 && positions[1] == 2) {
            return "YCbCr4:2:0";
        }
        return "(Unknown)";
    }

    public String getPlanarConfigurationDescription() {
        return this.getIndexedDescription(284, 1, "Chunky (contiguous for each subsampling pixel)", "Separate (Y-plane/Cb-plane/Cr-plane format)");
    }

    public String getSamplesPerPixelDescription() {
        String value = ((ExifSubIFDDirectory)this._directory).getString(277);
        return value == null ? null : value + " samples/pixel";
    }

    public String getRowsPerStripDescription() {
        String value = ((ExifSubIFDDirectory)this._directory).getString(278);
        return value == null ? null : value + " rows/strip";
    }

    public String getStripByteCountsDescription() {
        String value = ((ExifSubIFDDirectory)this._directory).getString(279);
        return value == null ? null : value + " bytes";
    }

    public String getPhotometricInterpretationDescription() {
        Integer value = ((ExifSubIFDDirectory)this._directory).getInteger(262);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                return "WhiteIsZero";
            }
            case 1: {
                return "BlackIsZero";
            }
            case 2: {
                return "RGB";
            }
            case 3: {
                return "RGB Palette";
            }
            case 4: {
                return "Transparency Mask";
            }
            case 5: {
                return "CMYK";
            }
            case 6: {
                return "YCbCr";
            }
            case 8: {
                return "CIELab";
            }
            case 9: {
                return "ICCLab";
            }
            case 10: {
                return "ITULab";
            }
            case 32803: {
                return "Color Filter Array";
            }
            case 32844: {
                return "Pixar LogL";
            }
            case 32845: {
                return "Pixar LogLuv";
            }
            case 32892: {
                return "Linear Raw";
            }
        }
        return "Unknown colour space";
    }

    public String getBitsPerSampleDescription() {
        String value = ((ExifSubIFDDirectory)this._directory).getString(258);
        return value == null ? null : value + " bits/component/pixel";
    }

    public String getFocalPlaneXResolutionDescription() {
        Rational rational = ((ExifSubIFDDirectory)this._directory).getRational(41486);
        if (rational == null) {
            return null;
        }
        String unit = this.getFocalPlaneResolutionUnitDescription();
        return rational.getReciprocal().toSimpleString(true) + (unit == null ? "" : " " + unit.toLowerCase());
    }

    public String getFocalPlaneYResolutionDescription() {
        Rational rational = ((ExifSubIFDDirectory)this._directory).getRational(41487);
        if (rational == null) {
            return null;
        }
        String unit = this.getFocalPlaneResolutionUnitDescription();
        return rational.getReciprocal().toSimpleString(true) + (unit == null ? "" : " " + unit.toLowerCase());
    }

    public String getFocalPlaneResolutionUnitDescription() {
        return this.getIndexedDescription(41488, 1, "(No unit)", "Inches", "cm");
    }

    public String getExifImageWidthDescription() {
        Integer value = ((ExifSubIFDDirectory)this._directory).getInteger(40962);
        return value == null ? null : value + " pixels";
    }

    public String getExifImageHeightDescription() {
        Integer value = ((ExifSubIFDDirectory)this._directory).getInteger(40963);
        return value == null ? null : value + " pixels";
    }

    public String getColorSpaceDescription() {
        Integer value = ((ExifSubIFDDirectory)this._directory).getInteger(40961);
        if (value == null) {
            return null;
        }
        if (value == 1) {
            return "sRGB";
        }
        if (value == 65535) {
            return "Undefined";
        }
        return "Unknown (" + value + ")";
    }

    public String getFocalLengthDescription() {
        Rational value = ((ExifSubIFDDirectory)this._directory).getRational(37386);
        if (value == null) {
            return null;
        }
        DecimalFormat formatter = new DecimalFormat("0.0##");
        return formatter.format(value.doubleValue()) + " mm";
    }

    public String getFlashDescription() {
        Integer value = ((ExifSubIFDDirectory)this._directory).getInteger(37385);
        if (value == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        if ((value & 1) != 0) {
            sb.append("Flash fired");
        } else {
            sb.append("Flash did not fire");
        }
        if ((value & 4) != 0) {
            if ((value & 2) != 0) {
                sb.append(", return detected");
            } else {
                sb.append(", return not detected");
            }
        }
        if ((value & 0x10) != 0) {
            sb.append(", auto");
        }
        if ((value & 0x40) != 0) {
            sb.append(", red-eye reduction");
        }
        return sb.toString();
    }

    public String getWhiteBalanceDescription() {
        Integer value = ((ExifSubIFDDirectory)this._directory).getInteger(37384);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                return "Unknown";
            }
            case 1: {
                return "Daylight";
            }
            case 2: {
                return "Florescent";
            }
            case 3: {
                return "Tungsten";
            }
            case 10: {
                return "Flash";
            }
            case 17: {
                return "Standard light";
            }
            case 18: {
                return "Standard light (B)";
            }
            case 19: {
                return "Standard light (C)";
            }
            case 20: {
                return "D55";
            }
            case 21: {
                return "D65";
            }
            case 22: {
                return "D75";
            }
            case 255: {
                return "(Other)";
            }
        }
        return "Unknown (" + value + ")";
    }

    public String getMeteringModeDescription() {
        Integer value = ((ExifSubIFDDirectory)this._directory).getInteger(37383);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                return "Unknown";
            }
            case 1: {
                return "Average";
            }
            case 2: {
                return "Center weighted average";
            }
            case 3: {
                return "Spot";
            }
            case 4: {
                return "Multi-spot";
            }
            case 5: {
                return "Multi-segment";
            }
            case 6: {
                return "Partial";
            }
            case 255: {
                return "(Other)";
            }
        }
        return "";
    }

    public String getSubjectDistanceDescription() {
        Rational value = ((ExifSubIFDDirectory)this._directory).getRational(37382);
        if (value == null) {
            return null;
        }
        DecimalFormat formatter = new DecimalFormat("0.0##");
        return formatter.format(value.doubleValue()) + " metres";
    }

    public String getCompressedAverageBitsPerPixelDescription() {
        Rational value = ((ExifSubIFDDirectory)this._directory).getRational(37122);
        if (value == null) {
            return null;
        }
        String ratio = value.toSimpleString(true);
        return value.isInteger() && value.intValue() == 1 ? ratio + " bit/pixel" : ratio + " bits/pixel";
    }

    public String getExposureTimeDescription() {
        String value = ((ExifSubIFDDirectory)this._directory).getString(33434);
        return value == null ? null : value + " sec";
    }

    public String getShutterSpeedDescription() {
        Float apexValue = ((ExifSubIFDDirectory)this._directory).getFloatObject(37377);
        if (apexValue == null) {
            return null;
        }
        if (apexValue.floatValue() <= 1.0f) {
            float apexPower = (float)(1.0 / Math.exp((double)apexValue.floatValue() * Math.log(2.0)));
            long apexPower10 = Math.round((double)apexPower * 10.0);
            float fApexPower = (float)apexPower10 / 10.0f;
            return fApexPower + " sec";
        }
        int apexPower = (int)Math.exp((double)apexValue.floatValue() * Math.log(2.0));
        return "1/" + apexPower + " sec";
    }

    public String getFNumberDescription() {
        Rational value = ((ExifSubIFDDirectory)this._directory).getRational(33437);
        if (value == null) {
            return null;
        }
        return "F" + SimpleDecimalFormatter.format(value.doubleValue());
    }

    public String getSensingMethodDescription() {
        return this.getIndexedDescription(41495, 1, "(Not defined)", "One-chip color area sensor", "Two-chip color area sensor", "Three-chip color area sensor", "Color sequential area sensor", null, "Trilinear sensor", "Color sequential linear sensor");
    }

    public String getComponentConfigurationDescription() {
        int[] components = ((ExifSubIFDDirectory)this._directory).getIntArray(37121);
        if (components == null) {
            return null;
        }
        String[] componentStrings = new String[]{"", "Y", "Cb", "Cr", "R", "G", "B"};
        StringBuilder componentConfig = new StringBuilder();
        for (int i = 0; i < Math.min(4, components.length); ++i) {
            int j = components[i];
            if (j <= 0 || j >= componentStrings.length) continue;
            componentConfig.append(componentStrings[j]);
        }
        return componentConfig.toString();
    }
}

