/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.exif;

import com.drew.imaging.jpeg.JpegSegmentMetadataReader;
import com.drew.imaging.jpeg.JpegSegmentType;
import com.drew.imaging.tiff.TiffProcessingException;
import com.drew.imaging.tiff.TiffReader;
import com.drew.lang.ByteArrayReader;
import com.drew.metadata.Metadata;
import com.drew.metadata.exif.ExifTiffHandler;
import java.io.IOException;
import java.util.Arrays;

public class ExifReader
implements JpegSegmentMetadataReader {
    private boolean _storeThumbnailBytes = true;

    public boolean isStoreThumbnailBytes() {
        return this._storeThumbnailBytes;
    }

    public void setStoreThumbnailBytes(boolean storeThumbnailBytes) {
        this._storeThumbnailBytes = storeThumbnailBytes;
    }

    @Override
    public Iterable<JpegSegmentType> getSegmentTypes() {
        return Arrays.asList(JpegSegmentType.APP1);
    }

    @Override
    public boolean canProcess(byte[] segmentBytes, JpegSegmentType segmentType) {
        return segmentBytes.length >= "Exif\u0000\u0000".length() && new String(segmentBytes, 0, "Exif\u0000\u0000".length()).equalsIgnoreCase("Exif\u0000\u0000");
    }

    @Override
    public void extract(byte[] segmentBytes, Metadata metadata, JpegSegmentType segmentType) {
        if (segmentBytes == null) {
            throw new NullPointerException("segmentBytes cannot be null");
        }
        if (metadata == null) {
            throw new NullPointerException("metadata cannot be null");
        }
        if (segmentType == null) {
            throw new NullPointerException("segmentType cannot be null");
        }
        try {
            ByteArrayReader reader = new ByteArrayReader(segmentBytes);
            try {
                if (!reader.getString(0, "Exif\u0000\u0000".length()).equals("Exif\u0000\u0000")) {
                    System.err.println("Invalid JPEG Exif segment preamble");
                    return;
                }
            }
            catch (IOException e) {
                e.printStackTrace(System.err);
                return;
            }
            new TiffReader().processTiff(reader, new ExifTiffHandler(metadata, this._storeThumbnailBytes), "Exif\u0000\u0000".length());
        }
        catch (TiffProcessingException e) {
            e.printStackTrace(System.err);
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
        }
    }
}

