/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata;

import com.drew.metadata.Directory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class Metadata {
    private final Map<Class<? extends Directory>, Directory> _directoryByClass = new HashMap<Class<? extends Directory>, Directory>();
    private final Collection<Directory> _directoryList = new ArrayList<Directory>();

    public Iterable<Directory> getDirectories() {
        return Collections.unmodifiableCollection(this._directoryList);
    }

    public int getDirectoryCount() {
        return this._directoryList.size();
    }

    public <T extends Directory> T getOrCreateDirectory(Class<T> type) {
        Directory directory;
        if (this._directoryByClass.containsKey(type)) {
            return (T)this._directoryByClass.get(type);
        }
        try {
            directory = (Directory)type.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot instantiate provided Directory type: " + type.toString());
        }
        this._directoryByClass.put(type, directory);
        this._directoryList.add(directory);
        return (T)directory;
    }

    public <T extends Directory> T getDirectory(Class<T> type) {
        return (T)this._directoryByClass.get(type);
    }

    public boolean containsDirectory(Class<? extends Directory> type) {
        return this._directoryByClass.containsKey(type);
    }

    public boolean hasErrors() {
        for (Directory directory : this._directoryList) {
            if (!directory.hasErrors()) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return String.format("Metadata (%d %s)", this._directoryList.size(), this._directoryList.size() == 1 ? "directory" : "directories");
    }
}

