/*
 * Decompiled with CFR 0.152.
 */
package com.drew.lang;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Iterator;

public class StringUtil {
    public static String join(Iterable<? extends CharSequence> strings, String delimiter) {
        int capacity = 0;
        int delimLength = delimiter.length();
        Iterator<? extends CharSequence> iter = strings.iterator();
        if (iter.hasNext()) {
            capacity += iter.next().length() + delimLength;
        }
        StringBuilder buffer = new StringBuilder(capacity);
        iter = strings.iterator();
        if (iter.hasNext()) {
            buffer.append(iter.next());
            while (iter.hasNext()) {
                buffer.append(delimiter);
                buffer.append(iter.next());
            }
        }
        return buffer.toString();
    }

    public static <T extends CharSequence> String join(T[] strings, String delimiter) {
        int capacity = 0;
        int delimLength = delimiter.length();
        for (T value : strings) {
            capacity += value.length() + delimLength;
        }
        StringBuilder buffer = new StringBuilder(capacity);
        boolean first = true;
        for (T value : strings) {
            if (!first) {
                buffer.append(delimiter);
            } else {
                first = false;
            }
            buffer.append((CharSequence)value);
        }
        return buffer.toString();
    }

    public static String fromStream(InputStream stream) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        StringBuilder sb = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            sb.append(line);
        }
        return sb.toString();
    }

    public static int compare(String s1, String s2) {
        boolean null2;
        boolean null1 = s1 == null;
        boolean bl = null2 = s2 == null;
        if (null1 && null2) {
            return 0;
        }
        if (null1) {
            return -1;
        }
        if (null2) {
            return 1;
        }
        return s1.compareTo(s2);
    }

    public static String urlEncode(String name) {
        return name.replace(" ", "%20");
    }
}

