/*
 * Decompiled with CFR 0.152.
 */
package com.drew.lang;

import java.io.IOException;
import java.io.UnsupportedEncodingException;

public abstract class RandomAccessReader {
    private boolean _isMotorolaByteOrder = true;

    protected abstract byte getByte(int var1) throws IOException;

    public abstract byte[] getBytes(int var1, int var2) throws IOException;

    protected abstract void validateIndex(int var1, int var2) throws IOException;

    protected abstract boolean isValidIndex(int var1, int var2) throws IOException;

    public abstract long getLength() throws IOException;

    public void setMotorolaByteOrder(boolean motorolaByteOrder) {
        this._isMotorolaByteOrder = motorolaByteOrder;
    }

    public boolean isMotorolaByteOrder() {
        return this._isMotorolaByteOrder;
    }

    public short getUInt8(int index) throws IOException {
        this.validateIndex(index, 1);
        return (short)(this.getByte(index) & 0xFF);
    }

    public byte getInt8(int index) throws IOException {
        this.validateIndex(index, 1);
        return this.getByte(index);
    }

    public int getUInt16(int index) throws IOException {
        this.validateIndex(index, 2);
        if (this._isMotorolaByteOrder) {
            return this.getByte(index) << 8 & 0xFF00 | this.getByte(index + 1) & 0xFF;
        }
        return this.getByte(index + 1) << 8 & 0xFF00 | this.getByte(index) & 0xFF;
    }

    public short getInt16(int index) throws IOException {
        this.validateIndex(index, 2);
        if (this._isMotorolaByteOrder) {
            return (short)((short)this.getByte(index) << 8 & 0xFFFFFF00 | (short)this.getByte(index + 1) & 0xFF);
        }
        return (short)((short)this.getByte(index + 1) << 8 & 0xFFFFFF00 | (short)this.getByte(index) & 0xFF);
    }

    public long getUInt32(int index) throws IOException {
        this.validateIndex(index, 4);
        if (this._isMotorolaByteOrder) {
            return (long)this.getByte(index) << 24 & 0xFF000000L | (long)this.getByte(index + 1) << 16 & 0xFF0000L | (long)this.getByte(index + 2) << 8 & 0xFF00L | (long)this.getByte(index + 3) & 0xFFL;
        }
        return (long)this.getByte(index + 3) << 24 & 0xFF000000L | (long)this.getByte(index + 2) << 16 & 0xFF0000L | (long)this.getByte(index + 1) << 8 & 0xFF00L | (long)this.getByte(index) & 0xFFL;
    }

    public int getInt32(int index) throws IOException {
        this.validateIndex(index, 4);
        if (this._isMotorolaByteOrder) {
            return this.getByte(index) << 24 & 0xFF000000 | this.getByte(index + 1) << 16 & 0xFF0000 | this.getByte(index + 2) << 8 & 0xFF00 | this.getByte(index + 3) & 0xFF;
        }
        return this.getByte(index + 3) << 24 & 0xFF000000 | this.getByte(index + 2) << 16 & 0xFF0000 | this.getByte(index + 1) << 8 & 0xFF00 | this.getByte(index) & 0xFF;
    }

    public long getInt64(int index) throws IOException {
        this.validateIndex(index, 8);
        if (this._isMotorolaByteOrder) {
            return (long)this.getByte(index) << 56 & 0xFF00000000000000L | (long)this.getByte(index + 1) << 48 & 0xFF000000000000L | (long)this.getByte(index + 2) << 40 & 0xFF0000000000L | (long)this.getByte(index + 3) << 32 & 0xFF00000000L | (long)this.getByte(index + 4) << 24 & 0xFF000000L | (long)this.getByte(index + 5) << 16 & 0xFF0000L | (long)this.getByte(index + 6) << 8 & 0xFF00L | (long)this.getByte(index + 7) & 0xFFL;
        }
        return (long)this.getByte(index + 7) << 56 & 0xFF00000000000000L | (long)this.getByte(index + 6) << 48 & 0xFF000000000000L | (long)this.getByte(index + 5) << 40 & 0xFF0000000000L | (long)this.getByte(index + 4) << 32 & 0xFF00000000L | (long)this.getByte(index + 3) << 24 & 0xFF000000L | (long)this.getByte(index + 2) << 16 & 0xFF0000L | (long)this.getByte(index + 1) << 8 & 0xFF00L | (long)this.getByte(index) & 0xFFL;
    }

    public float getS15Fixed16(int index) throws IOException {
        this.validateIndex(index, 4);
        if (this._isMotorolaByteOrder) {
            float res = (this.getByte(index) & 0xFF) << 8 | this.getByte(index + 1) & 0xFF;
            int d = (this.getByte(index + 2) & 0xFF) << 8 | this.getByte(index + 3) & 0xFF;
            return (float)((double)res + (double)d / 65536.0);
        }
        float res = (this.getByte(index + 3) & 0xFF) << 8 | this.getByte(index + 2) & 0xFF;
        int d = (this.getByte(index + 1) & 0xFF) << 8 | this.getByte(index) & 0xFF;
        return (float)((double)res + (double)d / 65536.0);
    }

    public float getFloat32(int index) throws IOException {
        return Float.intBitsToFloat(this.getInt32(index));
    }

    public double getDouble64(int index) throws IOException {
        return Double.longBitsToDouble(this.getInt64(index));
    }

    public String getString(int index, int bytesRequested) throws IOException {
        return new String(this.getBytes(index, bytesRequested));
    }

    public String getString(int index, int bytesRequested, String charset) throws IOException {
        byte[] bytes = this.getBytes(index, bytesRequested);
        try {
            return new String(bytes, charset);
        }
        catch (UnsupportedEncodingException e) {
            return new String(bytes);
        }
    }

    public String getNullTerminatedString(int index, int maxLengthBytes) throws IOException {
        int length;
        byte[] bytes = this.getBytes(index, maxLengthBytes);
        for (length = 0; length < bytes.length && bytes[length] != 0; ++length) {
        }
        return new String(bytes, 0, length);
    }
}

