/*
 * Decompiled with CFR 0.152.
 */
package com.drew.lang;

import java.io.IOException;

public final class BufferBoundsException
extends IOException {
    public BufferBoundsException(int index, int bytesRequested, long bufferLength) {
        super(BufferBoundsException.getMessage(index, bytesRequested, bufferLength));
    }

    public BufferBoundsException(String message) {
        super(message);
    }

    private static String getMessage(int index, int bytesRequested, long bufferLength) {
        if (index < 0) {
            return String.format("Attempt to read from buffer using a negative index (%d)", index);
        }
        if (bytesRequested < 0) {
            return String.format("Number of requested bytes cannot be negative (%d)", bytesRequested);
        }
        if ((long)index + (long)bytesRequested - 1L > Integer.MAX_VALUE) {
            return String.format("Number of requested bytes summed with starting index exceed maximum range of signed 32 bit integers (requested index: %d, requested count: %d)", index, bytesRequested);
        }
        return String.format("Attempt to read from beyond end of underlying data source (requested index: %d, requested count: %d, max index: %d)", index, bytesRequested, bufferLength - 1L);
    }
}

