/*
 * Decompiled with CFR 0.152.
 */
package com.drew.imaging.tiff;

import com.drew.imaging.tiff.TiffDataFormat;
import com.drew.imaging.tiff.TiffHandler;
import com.drew.imaging.tiff.TiffProcessingException;
import com.drew.lang.RandomAccessReader;
import com.drew.lang.Rational;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public class TiffReader {
    public void processTiff(RandomAccessReader reader, TiffHandler handler, int tiffHeaderOffset) throws TiffProcessingException, IOException {
        short byteOrderIdentifier = reader.getInt16(tiffHeaderOffset);
        if (byteOrderIdentifier == 19789) {
            reader.setMotorolaByteOrder(true);
        } else if (byteOrderIdentifier == 18761) {
            reader.setMotorolaByteOrder(false);
        } else {
            throw new TiffProcessingException("Unclear distinction between Motorola/Intel byte ordering: " + byteOrderIdentifier);
        }
        int tiffMarker = reader.getUInt16(2 + tiffHeaderOffset);
        handler.setTiffMarker(tiffMarker);
        int firstIfdOffset = reader.getInt32(4 + tiffHeaderOffset) + tiffHeaderOffset;
        if ((long)firstIfdOffset >= reader.getLength() - 1L) {
            handler.warn("First IFD offset is beyond the end of the TIFF data segment -- trying default offset");
            firstIfdOffset = tiffHeaderOffset + 2 + 2 + 4;
        }
        HashSet<Integer> processedIfdOffsets = new HashSet<Integer>();
        TiffReader.processIfd(handler, reader, processedIfdOffsets, firstIfdOffset, tiffHeaderOffset);
        handler.completed(reader, tiffHeaderOffset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void processIfd(TiffHandler handler, RandomAccessReader reader, Set<Integer> processedIfdOffsets, int ifdOffset, int tiffHeaderOffset) throws IOException {
        try {
            if (processedIfdOffsets.contains(ifdOffset)) {
                return;
            }
            processedIfdOffsets.add(ifdOffset);
            if ((long)ifdOffset >= reader.getLength() || ifdOffset < 0) {
                handler.error("Ignored IFD marked to start outside data segment");
                return;
            }
            int dirTagCount = reader.getUInt16(ifdOffset);
            int dirLength = 2 + 12 * dirTagCount + 4;
            if ((long)(dirLength + ifdOffset) > reader.getLength()) {
                handler.error("Illegally sized IFD");
                return;
            }
            int invalidTiffFormatCodeCount = 0;
            for (int tagNumber = 0; tagNumber < dirTagCount; ++tagNumber) {
                int tagValueOffset;
                int tagOffset = TiffReader.calculateTagOffset(ifdOffset, tagNumber);
                int tagId = reader.getUInt16(tagOffset);
                int formatCode = reader.getUInt16(tagOffset + 2);
                TiffDataFormat format = TiffDataFormat.fromTiffFormatCode(formatCode);
                if (format == null) {
                    handler.error("Invalid TIFF tag format code: " + formatCode);
                    if (++invalidTiffFormatCodeCount <= 5) continue;
                    handler.error("Stopping processing as too many errors seen in TIFF IFD");
                    return;
                }
                int componentCount = reader.getInt32(tagOffset + 4);
                if (componentCount < 0) {
                    handler.error("Negative TIFF tag component count");
                    continue;
                }
                int byteCount = componentCount * format.getComponentSizeBytes();
                if (byteCount > 4) {
                    int offsetVal = reader.getInt32(tagOffset + 8);
                    if ((long)(offsetVal + byteCount) > reader.getLength()) {
                        handler.error("Illegal TIFF tag pointer offset");
                        continue;
                    }
                    tagValueOffset = tiffHeaderOffset + offsetVal;
                } else {
                    tagValueOffset = tagOffset + 8;
                }
                if (tagValueOffset < 0 || (long)tagValueOffset > reader.getLength()) {
                    handler.error("Illegal TIFF tag pointer offset");
                    continue;
                }
                if (byteCount < 0 || (long)(tagValueOffset + byteCount) > reader.getLength()) {
                    handler.error("Illegal number of bytes for TIFF tag data: " + byteCount);
                    continue;
                }
                if (byteCount == 4 && handler.isTagIfdPointer(tagId)) {
                    int subDirOffset = tiffHeaderOffset + reader.getInt32(tagValueOffset);
                    TiffReader.processIfd(handler, reader, processedIfdOffsets, subDirOffset, tiffHeaderOffset);
                    continue;
                }
                if (handler.customProcessTag(tagValueOffset, processedIfdOffsets, tiffHeaderOffset, reader, tagId, byteCount)) continue;
                TiffReader.processTag(handler, tagId, tagValueOffset, componentCount, formatCode, reader);
            }
            int finalTagOffset = TiffReader.calculateTagOffset(ifdOffset, dirTagCount);
            int nextIfdOffset = reader.getInt32(finalTagOffset);
            if (nextIfdOffset != 0) {
                if ((long)(nextIfdOffset += tiffHeaderOffset) >= reader.getLength()) {
                    return;
                }
                if (nextIfdOffset < ifdOffset) {
                    return;
                }
                if (handler.hasFollowerIfd()) {
                    TiffReader.processIfd(handler, reader, processedIfdOffsets, nextIfdOffset, tiffHeaderOffset);
                }
            }
        }
        finally {
            handler.endingIFD();
        }
    }

    private static void processTag(TiffHandler handler, int tagId, int tagValueOffset, int componentCount, int formatCode, RandomAccessReader reader) throws IOException {
        switch (formatCode) {
            case 7: {
                handler.setByteArray(tagId, reader.getBytes(tagValueOffset, componentCount));
                break;
            }
            case 2: {
                handler.setString(tagId, reader.getNullTerminatedString(tagValueOffset, componentCount));
                break;
            }
            case 10: {
                if (componentCount == 1) {
                    handler.setRational(tagId, new Rational(reader.getInt32(tagValueOffset), reader.getInt32(tagValueOffset + 4)));
                    break;
                }
                if (componentCount <= 1) break;
                Rational[] array = new Rational[componentCount];
                for (int i = 0; i < componentCount; ++i) {
                    array[i] = new Rational(reader.getInt32(tagValueOffset + 8 * i), reader.getInt32(tagValueOffset + 4 + 8 * i));
                }
                handler.setRationalArray(tagId, array);
                break;
            }
            case 5: {
                if (componentCount == 1) {
                    handler.setRational(tagId, new Rational(reader.getUInt32(tagValueOffset), reader.getUInt32(tagValueOffset + 4)));
                    break;
                }
                if (componentCount <= 1) break;
                Rational[] array = new Rational[componentCount];
                for (int i = 0; i < componentCount; ++i) {
                    array[i] = new Rational(reader.getUInt32(tagValueOffset + 8 * i), reader.getUInt32(tagValueOffset + 4 + 8 * i));
                }
                handler.setRationalArray(tagId, array);
                break;
            }
            case 11: {
                if (componentCount == 1) {
                    handler.setFloat(tagId, reader.getFloat32(tagValueOffset));
                    break;
                }
                float[] array = new float[componentCount];
                for (int i = 0; i < componentCount; ++i) {
                    array[i] = reader.getFloat32(tagValueOffset + i * 4);
                }
                handler.setFloatArray(tagId, array);
                break;
            }
            case 12: {
                if (componentCount == 1) {
                    handler.setDouble(tagId, reader.getDouble64(tagValueOffset));
                    break;
                }
                double[] array = new double[componentCount];
                for (int i = 0; i < componentCount; ++i) {
                    array[i] = reader.getDouble64(tagValueOffset + i * 4);
                }
                handler.setDoubleArray(tagId, array);
                break;
            }
            case 6: {
                if (componentCount == 1) {
                    handler.setInt8s(tagId, reader.getInt8(tagValueOffset));
                    break;
                }
                byte[] array = new byte[componentCount];
                for (int i = 0; i < componentCount; ++i) {
                    array[i] = reader.getInt8(tagValueOffset + i);
                }
                handler.setInt8sArray(tagId, array);
                break;
            }
            case 1: {
                if (componentCount == 1) {
                    handler.setInt8u(tagId, reader.getUInt8(tagValueOffset));
                    break;
                }
                short[] array = new short[componentCount];
                for (int i = 0; i < componentCount; ++i) {
                    array[i] = reader.getUInt8(tagValueOffset + i);
                }
                handler.setInt8uArray(tagId, array);
                break;
            }
            case 8: {
                if (componentCount == 1) {
                    handler.setInt16s(tagId, reader.getInt16(tagValueOffset));
                    break;
                }
                short[] array = new short[componentCount];
                for (int i = 0; i < componentCount; ++i) {
                    array[i] = reader.getInt16(tagValueOffset + i * 2);
                }
                handler.setInt16sArray(tagId, array);
                break;
            }
            case 3: {
                if (componentCount == 1) {
                    handler.setInt16u(tagId, reader.getUInt16(tagValueOffset));
                    break;
                }
                int[] array = new int[componentCount];
                for (int i = 0; i < componentCount; ++i) {
                    array[i] = reader.getUInt16(tagValueOffset + i * 2);
                }
                handler.setInt16uArray(tagId, array);
                break;
            }
            case 9: {
                if (componentCount == 1) {
                    handler.setInt32s(tagId, reader.getInt32(tagValueOffset));
                    break;
                }
                int[] array = new int[componentCount];
                for (int i = 0; i < componentCount; ++i) {
                    array[i] = reader.getInt32(tagValueOffset + i * 4);
                }
                handler.setInt32sArray(tagId, array);
                break;
            }
            case 4: {
                if (componentCount == 1) {
                    handler.setInt32u(tagId, reader.getUInt32(tagValueOffset));
                    break;
                }
                long[] array = new long[componentCount];
                for (int i = 0; i < componentCount; ++i) {
                    array[i] = reader.getUInt32(tagValueOffset + i * 4);
                }
                handler.setInt32uArray(tagId, array);
                break;
            }
            default: {
                handler.error(String.format("Unknown format code %d for tag %d", formatCode, tagId));
            }
        }
    }

    private static int calculateTagOffset(int ifdStartOffset, int entryNumber) {
        return ifdStartOffset + 2 + 12 * entryNumber;
    }
}

