/*
 * Decompiled with CFR 0.152.
 */
package com.drew.imaging.jpeg;

import com.drew.imaging.jpeg.JpegProcessingException;
import com.drew.imaging.jpeg.JpegSegmentData;
import com.drew.imaging.jpeg.JpegSegmentType;
import com.drew.lang.SequentialReader;
import com.drew.lang.StreamReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashSet;

public class JpegSegmentReader {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JpegSegmentData readSegments(File file, Iterable<JpegSegmentType> segmentTypes) throws JpegProcessingException, IOException {
        try (FileInputStream stream = null;){
            stream = new FileInputStream(file);
            JpegSegmentData jpegSegmentData = JpegSegmentReader.readSegments(new StreamReader(stream), segmentTypes);
            return jpegSegmentData;
        }
    }

    public static JpegSegmentData readSegments(SequentialReader reader, Iterable<JpegSegmentType> segmentTypes) throws JpegProcessingException, IOException {
        assert (reader.isMotorolaByteOrder());
        int magicNumber = reader.getUInt16();
        if (magicNumber != 65496) {
            throw new JpegProcessingException("JPEG data is expected to begin with 0xFFD8 (\u00c3\u00bf\u00c3\u0098) not 0x" + Integer.toHexString(magicNumber));
        }
        HashSet<Byte> segmentTypeBytes = null;
        if (segmentTypes != null) {
            segmentTypeBytes = new HashSet<Byte>();
            for (JpegSegmentType segmentType : segmentTypes) {
                segmentTypeBytes.add(segmentType.byteValue);
            }
        }
        JpegSegmentData segmentData = new JpegSegmentData();
        while (true) {
            short segmentIdentifier;
            if ((segmentIdentifier = reader.getUInt8()) != 255) {
                throw new JpegProcessingException("Expected JPEG segment start identifier 0xFF, not 0x" + Integer.toHexString(segmentIdentifier).toUpperCase());
            }
            byte segmentType = reader.getInt8();
            while (segmentType == -1) {
                segmentType = reader.getInt8();
            }
            if (segmentType == 0) {
                throw new JpegProcessingException("Expected non-zero byte as part of JPEG marker identifier");
            }
            if (segmentType == -38) {
                return segmentData;
            }
            if (segmentType == -39) {
                return segmentData;
            }
            int segmentLength = reader.getUInt16();
            if ((segmentLength -= 2) < 0) {
                throw new JpegProcessingException("JPEG segment size would be less than zero");
            }
            if (segmentTypeBytes == null || segmentTypeBytes.contains(segmentType)) {
                byte[] segmentBytes = reader.getBytes(segmentLength);
                assert (segmentLength == segmentBytes.length);
                segmentData.addSegment(segmentType, segmentBytes);
                continue;
            }
            if (!reader.trySkip(segmentLength)) break;
        }
        return segmentData;
    }

    private JpegSegmentReader() throws Exception {
        throw new Exception("Not intended for instantiation.");
    }
}

