/*
 * Decompiled with CFR 0.152.
 */
package com.drew.imaging.jpeg;

import com.drew.imaging.jpeg.JpegProcessingException;
import com.drew.imaging.jpeg.JpegSegmentData;
import com.drew.imaging.jpeg.JpegSegmentMetadataReader;
import com.drew.imaging.jpeg.JpegSegmentReader;
import com.drew.imaging.jpeg.JpegSegmentType;
import com.drew.lang.StreamReader;
import com.drew.metadata.Metadata;
import com.drew.metadata.exif.ExifReader;
import com.drew.metadata.iptc.IptcReader;
import com.drew.metadata.jpeg.JpegCommentReader;
import com.drew.metadata.jpeg.JpegReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashSet;

public class JpegMetadataReader {
    public static final Iterable<JpegSegmentMetadataReader> ALL_READERS = Arrays.asList(new JpegReader(), new JpegCommentReader(), new ExifReader(), new IptcReader());

    public static Metadata readMetadata(InputStream inputStream, Iterable<JpegSegmentMetadataReader> readers) throws JpegProcessingException, IOException {
        Metadata metadata = new Metadata();
        JpegMetadataReader.process(metadata, inputStream, readers);
        return metadata;
    }

    public static Metadata readMetadata(InputStream inputStream) throws JpegProcessingException, IOException {
        return JpegMetadataReader.readMetadata(inputStream, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Metadata readMetadata(File file, Iterable<JpegSegmentMetadataReader> readers) throws JpegProcessingException, IOException {
        try (FileInputStream inputStream = null;){
            inputStream = new FileInputStream(file);
            Metadata metadata = JpegMetadataReader.readMetadata(inputStream, readers);
            return metadata;
        }
    }

    public static Metadata readMetadata(File file) throws JpegProcessingException, IOException {
        return JpegMetadataReader.readMetadata(file, null);
    }

    public static void process(Metadata metadata, InputStream inputStream) throws JpegProcessingException, IOException {
        JpegMetadataReader.process(metadata, inputStream, null);
    }

    public static void process(Metadata metadata, InputStream inputStream, Iterable<JpegSegmentMetadataReader> readers) throws JpegProcessingException, IOException {
        if (readers == null) {
            readers = ALL_READERS;
        }
        HashSet<JpegSegmentType> segmentTypes = new HashSet<JpegSegmentType>();
        for (JpegSegmentMetadataReader reader : readers) {
            for (JpegSegmentType type : reader.getSegmentTypes()) {
                segmentTypes.add(type);
            }
        }
        JpegSegmentData segmentData = JpegSegmentReader.readSegments(new StreamReader(inputStream), segmentTypes);
        JpegMetadataReader.processJpegSegmentData(metadata, readers, segmentData);
    }

    public static void processJpegSegmentData(Metadata metadata, Iterable<JpegSegmentMetadataReader> readers, JpegSegmentData segmentData) {
        for (JpegSegmentMetadataReader reader : readers) {
            for (JpegSegmentType segmentType : reader.getSegmentTypes()) {
                for (byte[] segmentBytes : segmentData.getSegments(segmentType)) {
                    if (!reader.canProcess(segmentBytes, segmentType)) continue;
                    reader.extract(segmentBytes, metadata, segmentType);
                }
            }
        }
    }
}

